/*=============================================================================}
{ This demo shows mouse events, not connected with hypertext IDs               }
{ - OnRVMouseDown, OnRVMouseUp, OnRVDblClick, OnRVRightClick;                  }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "CRVFData.hpp"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichView1->AddNLATag("More mouse events",1,1,0);
  RichView1->AddTextNLA("There are some more mouse events in RichView\n"
    "Left/Right/Double - click in this Window.",0,0,0);

  TIcon* ico = new TIcon;
  ico->Assign(Image1->Picture->Graphic);
  RichView1->AddPictureEx("Notebook image",ico,1, rvvaMiddle);
  RichView1->AddNLATag(" - example of image",0,-1,0);

  RichView1->Format();
}
//---------------------------------------------------------------------------
AnsiString TForm1::MouseInfo(TMouseButton Button, TShiftState Shift, int ItemNo, int X, int Y)
{
  AnsiString ButtonStr, Word;
  ButtonStr = "";
  switch (Button)
  {
    case mbLeft:
      ButtonStr = "Left button";
      break;
    case mbRight:
      ButtonStr = "Right button";
      break;
    case mbMiddle:
      ButtonStr = "Middle button";
      break;
  }
  if (ItemNo!=-1)
  {
    Word = RichView1->GetWordAt(X,Y);
    return Format("%s at (%d,%d), at item #%d, at word '%s'",
                  ARRAYOFCONST((ButtonStr.c_str(), X,Y, ItemNo, Word.c_str())));
  }
  else
    return Format("%s at (%d,%d) - no item at this position",
                  ARRAYOFCONST((ButtonStr, X,Y)));
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1RVMouseDown(TCustomRichView *Sender,
    TMouseButton Button, TShiftState Shift, int ItemNo, int X, int Y)
{
  panMouseDown->Caption = "MouseDown: "+MouseInfo(Button, Shift, ItemNo, X, Y);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1RVMouseUp(TCustomRichView *Sender,
    TMouseButton Button, TShiftState Shift, int ItemNo, int X, int Y)
{
  panMouseUp->Caption = "MouseUp: "+MouseInfo(Button, Shift, ItemNo, X, Y);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1RVDblClick(TCustomRichView *Sender,
    TRVRawByteString ClickedWord, int Style)
{
  // This implementation does not support Unicode text items.
  // For Unicode text items, ClickedWord contains "raw Unicode", it must be
  // converted to ANSI or Unicode string before using.
  // See the demo for C++Builder 2009+ for details (Demos\CBuilderUnicode\)
  panDblClick->Caption = "DoubleClick: at word='"+ClickedWord+"', at item having style="+
    IntToStr(Style);
}
//---------------------------------------------------------------------------
// This event is obsolete. Use OnRVMouseUp instead
void __fastcall TForm1::RichView1RVRightClick(TCustomRichView *Sender,
    TRVRawByteString ClickedWord, int Style, int X, int Y)
{
  // This implementation does not support Unicode text items.
  // For Unicode text items, ClickedWord contains "raw Unicode", it must be
  // converted to ANSI or Unicode string before using.
  // See the demo for C++Builder 2009+ for details (Demos\CBuilderUnicode\)
  panRightClick->Caption = Format("RightClick: at (%d,%d), at word='%s', at item having style=%d",
    ARRAYOFCONST((X,Y,ClickedWord,Style)));
}
//---------------------------------------------------------------------------